package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

import com.yandex.ydb.core.Status;

/**
 * Create semaphore result response. The result of semaphore creation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateSemaphoreResultResponse {

    private final long reqId;
    private final Status status;

    public CreateSemaphoreResultResponse(long reqId, Status status) {
        this.reqId = reqId;
        this.status = status;
    }

    public long getReqId() {
        return reqId;
    }

    public Status getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateSemaphoreResultResponse that = (CreateSemaphoreResultResponse) o;
        return reqId == that.reqId &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, status);
    }

    @Override
    public String toString() {
        return "CreateSemaphoreResultResponse{" +
                "reqId=" + reqId +
                ", status=" + status +
                '}';
    }

}
