package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Delete semaphore request. Used to delete an existing semaphore.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DeleteSemaphoreRequest {

    private final long reqId;
    private final String name;
    private final boolean force;

    public DeleteSemaphoreRequest(long reqId, String name, boolean force) {
        this.reqId = reqId;
        this.name = name;
        this.force = force;
    }

    /**
     * Get client-defined request id, echoed in the response.
     * @return Client-defined request id.
     */
    public long getReqId() {
        return reqId;
    }

    /**
     * Get name of the semaphore to delete.
     * @return Name of the semaphore to delete.
     */
    public String getName() {
        return name;
    }

    /**
     * Will delete semaphore even if currently acquired by sessions.
     * @return Force delete flag.
     */
    public boolean isForce() {
        return force;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteSemaphoreRequest that = (DeleteSemaphoreRequest) o;
        return reqId == that.reqId &&
                force == that.force &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, name, force);
    }

    @Override
    public String toString() {
        return "DeleteSemaphoreRequest{" +
                "reqId=" + reqId +
                ", name='" + name + '\'' +
                ", force=" + force +
                '}';
    }

}
