package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Describe semaphore changed response. Used to report a change in the watched semaphore.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DescribeSemaphoreChangedResponse {

    private final long reqId;
    private final boolean dataChanged;
    private final boolean ownersChanged;

    public DescribeSemaphoreChangedResponse(long reqId, boolean dataChanged, boolean ownersChanged) {
        this.reqId = reqId;
        this.dataChanged = dataChanged;
        this.ownersChanged = ownersChanged;
    }

    public long getReqId() {
        return reqId;
    }

    public boolean isDataChanged() {
        return dataChanged;
    }

    public boolean isOwnersChanged() {
        return ownersChanged;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DescribeSemaphoreChangedResponse that = (DescribeSemaphoreChangedResponse) o;
        return reqId == that.reqId &&
                dataChanged == that.dataChanged &&
                ownersChanged == that.ownersChanged;
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, dataChanged, ownersChanged);
    }

    @Override
    public String toString() {
        return "DescribeSemaphoreChangedResponse{" +
                "reqId=" + reqId +
                ", dataChanged=" + dataChanged +
                ", ownersChanged=" + ownersChanged +
                '}';
    }

}
