package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

import com.yandex.ydb.core.Status;

/**
 * Describe semaphore result response. The result of the describe operation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DescribeSemaphoreResultResponse {

    private final long reqId;
    private final Status status;
    private final CoordinationSemaphoreDescription semaphoreDescription;
    private final boolean watchAdded;

    public DescribeSemaphoreResultResponse(long reqId, Status status,
                                           CoordinationSemaphoreDescription semaphoreDescription,
                                           boolean watchAdded) {
        this.reqId = reqId;
        this.status = status;
        this.semaphoreDescription = semaphoreDescription;
        this.watchAdded = watchAdded;
    }

    public long getReqId() {
        return reqId;
    }

    public Status getStatus() {
        return status;
    }

    public CoordinationSemaphoreDescription getSemaphoreDescription() {
        return semaphoreDescription;
    }

    /**
     * Returns true if a watch has been added for the semaphore.
     * @return True if a watch has been added for the semaphore.
     */
    public boolean isWatchAdded() {
        return watchAdded;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DescribeSemaphoreResultResponse that = (DescribeSemaphoreResultResponse) o;
        return reqId == that.reqId &&
                watchAdded == that.watchAdded &&
                Objects.equals(status, that.status) &&
                Objects.equals(semaphoreDescription, that.semaphoreDescription);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, status, semaphoreDescription, watchAdded);
    }

    @Override
    public String toString() {
        return "DescribeSemaphoreResultResponse{" +
                "reqId=" + reqId +
                ", status=" + status +
                ", semaphoreDescription=" + semaphoreDescription +
                ", watchAdded=" + watchAdded +
                '}';
    }

}
