package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

import com.yandex.ydb.core.Status;

/**
 * Failure response. Used to report connection and session level failures.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class FailureResponse {

    private final Status status;

    public FailureResponse(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FailureResponse that = (FailureResponse) o;
        return Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status);
    }

    @Override
    public String toString() {
        return "FailureResponse{" +
                "status=" + status +
                '}';
    }

}
