package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * PingPong response. Used for checking liveness of the connection.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class PingPongResponse {

    private final long opaque;

    public PingPongResponse(long opaque) {
        this.opaque = opaque;
    }

    /**
     * Opaque number specified in the ping message is echoed in the pong message.
     * @return Opaque number.
     */
    public long getOpaque() {
        return opaque;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PingPongResponse that = (PingPongResponse) o;
        return opaque == that.opaque;
    }

    @Override
    public int hashCode() {
        return Objects.hash(opaque);
    }

    @Override
    public String toString() {
        return "PingPongResponse{" +
                "opaque=" + opaque +
                '}';
    }

}
