package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Release semaphore request. Used to release a semaphore. A single session cannot release the same semaphore multiple
 * times. The release operation will either remove current session from waiters queue or release an already owned
 * semaphore.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReleaseSemaphoreRequest {

    private final long reqId;
    private final String name;

    public ReleaseSemaphoreRequest(long reqId, String name) {
        this.reqId = reqId;
        this.name = name;
    }

    /**
     * Get client-defined request id, echoed in the response.
     * @return Client-defined request id.
     */
    public long getReqId() {
        return reqId;
    }

    /**
     * Get name of the semaphore to release.
     * @return Name of the semaphore to release.
     */
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReleaseSemaphoreRequest that = (ReleaseSemaphoreRequest) o;
        return reqId == that.reqId &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, name);
    }

    @Override
    public String toString() {
        return "ReleaseSemaphoreRequest{" +
                "reqId=" + reqId +
                ", name='" + name + '\'' +
                '}';
    }

}
