package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

import com.yandex.ydb.core.Status;

/**
 * Release semaphore result response. Used by the server to report the result of a release operation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReleaseSemaphoreResultResponse {

    private final long reqId;
    private final Status status;
    private final boolean released;

    public ReleaseSemaphoreResultResponse(long reqId, Status status, boolean released) {
        this.reqId = reqId;
        this.status = status;
        this.released = released;
    }

    public long getReqId() {
        return reqId;
    }

    public Status getStatus() {
        return status;
    }

    /**
     * Returns true if semaphore was released, false if there was no active acquire operation.
     * @return True if semaphore was released, false if there was no active acquire operation.
     */
    public boolean isReleased() {
        return released;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReleaseSemaphoreResultResponse that = (ReleaseSemaphoreResultResponse) o;
        return reqId == that.reqId &&
                released == that.released &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, status, released);
    }

    @Override
    public String toString() {
        return "ReleaseSemaphoreResultResponse{" +
                "reqId=" + reqId +
                ", status=" + status +
                ", released=" + released +
                '}';
    }

}
