package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Semaphore change notification.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SemaphoreChangeNotification {

    private final CoordinationSemaphoreDescription name;
    private final boolean dataChanged;
    private final boolean ownersChanged;

    public SemaphoreChangeNotification(CoordinationSemaphoreDescription name, boolean dataChanged,
                                       boolean ownersChanged) {
        this.name = name;
        this.dataChanged = dataChanged;
        this.ownersChanged = ownersChanged;
    }

    public CoordinationSemaphoreDescription getName() {
        return name;
    }

    public boolean isDataChanged() {
        return dataChanged;
    }

    public boolean isOwnersChanged() {
        return ownersChanged;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SemaphoreChangeNotification that = (SemaphoreChangeNotification) o;
        return dataChanged == that.dataChanged &&
                ownersChanged == that.ownersChanged &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, dataChanged, ownersChanged);
    }

    @Override
    public String toString() {
        return "SemaphoreChangeNotification{" +
                "name=" + name +
                ", dataChanged=" + dataChanged +
                ", ownersChanged=" + ownersChanged +
                '}';
    }

}
