package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Semaphore event.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SemaphoreEvent {

    private final boolean dataChanged;
    private final boolean ownersChanged;

    public SemaphoreEvent(boolean dataChanged, boolean ownersChanged) {
        this.dataChanged = dataChanged;
        this.ownersChanged = ownersChanged;
    }

    public boolean isDataChanged() {
        return dataChanged;
    }

    public boolean isOwnersChanged() {
        return ownersChanged;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SemaphoreEvent that = (SemaphoreEvent) o;
        return dataChanged == that.dataChanged &&
                ownersChanged == that.ownersChanged;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dataChanged, ownersChanged);
    }

    @Override
    public String toString() {
        return "SemaphoreEvent{" +
                "dataChanged=" + dataChanged +
                ", ownersChanged=" + ownersChanged +
                '}';
    }

}
