package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.time.Duration;
import java.util.Objects;

/**
 * Session operation parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SessionOperationParameters {

    private final long deadlineAfterNanos;

    private SessionOperationParameters(long deadlineAfterNanos) {
        this.deadlineAfterNanos = deadlineAfterNanos;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getDeadlineAfterNanos() {
        return deadlineAfterNanos;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SessionOperationParameters that = (SessionOperationParameters) o;
        return deadlineAfterNanos == that.deadlineAfterNanos;
    }

    @Override
    public int hashCode() {
        return Objects.hash(deadlineAfterNanos);
    }

    @Override
    public String toString() {
        return "SessionOperationParameters{" +
                "deadlineAfterNanos=" + deadlineAfterNanos +
                '}';
    }

    public static final class Builder {

        private long deadlineAfterNanos = 0;

        private Builder() {
        }

        public Builder deadlineAfter(Duration deadlineAfter) {
            this.deadlineAfterNanos = System.nanoTime() + deadlineAfter.toNanos();
            return this;
        }

        public SessionOperationParameters build() {
            return new SessionOperationParameters(deadlineAfterNanos);
        }

    }

}
