package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.time.Duration;
import java.util.Objects;

/**
 * Session started response. Used to report a successful session create/restore operation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SessionStartedResponse {

    private final long sessionId;
    private final Duration timeout;

    public SessionStartedResponse(long sessionId, Duration timeout) {
        this.sessionId = sessionId;
        this.timeout = timeout;
    }

    /**
     * Get a server generation id that may be used for restoring the session.
     * @return Session id.
     */
    public long getSessionId() {
        return sessionId;
    }

    /**
     * Get timeout that will be used by the server.
     * @return Timeout.
     */
    public Duration getTimeout() {
        return timeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SessionStartedResponse that = (SessionStartedResponse) o;
        return sessionId == that.sessionId &&
                Objects.equals(timeout, that.timeout);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sessionId, timeout);
    }

    @Override
    public String toString() {
        return "SessionStartedResponse{" +
                "sessionId=" + sessionId +
                ", timeout=" + timeout +
                '}';
    }

}
