package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Session stopped response. Used to report a successful graceful termination of the session.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SessionStoppedResponse {

    private final long sessionId;

    public SessionStoppedResponse(long sessionId) {
        this.sessionId = sessionId;
    }

    public long getSessionId() {
        return sessionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SessionStoppedResponse that = (SessionStoppedResponse) o;
        return sessionId == that.sessionId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sessionId);
    }

    @Override
    public String toString() {
        return "SessionStoppedResponse{" +
                "sessionId=" + sessionId +
                '}';
    }

}
