package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Arrays;
import java.util.Objects;

/**
 * Update semaphore request. Used to change semaphore data.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class UpdateSemaphoreRequest {

    private final long reqId;
    private final String name;
    private final byte[] data;

    public UpdateSemaphoreRequest(long reqId, String name, byte[] data) {
        this.reqId = reqId;
        this.name = name;
        this.data = data;
    }

    /**
     * Get client-defined request id, echoed in the response.
     * @return Client-defined request id.
     */
    public long getReqId() {
        return reqId;
    }

    /**
     * Get name of the semaphore to update.
     * @return Name of the semaphore to update.
     */
    public String getName() {
        return name;
    }

    /**
     * Get user-defined data that is attached to the semaphore.
     * @return User-defined data that is attached to the semaphore.
     */
    public byte[] getData() {
        return data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateSemaphoreRequest that = (UpdateSemaphoreRequest) o;
        return reqId == that.reqId &&
                Objects.equals(name, that.name) &&
                Arrays.equals(data, that.data);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(reqId, name);
        result = 31 * result + Arrays.hashCode(data);
        return result;
    }

    @Override
    public String toString() {
        return "UpdateSemaphoreRequest{" +
                "reqId=" + reqId +
                ", name='" + name + '\'' +
                ", data=" + Arrays.toString(data) +
                '}';
    }

}
