package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

import com.yandex.ydb.core.Status;

/**
 * Update semaphore result response. The result of semaphore update.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class UpdateSemaphoreResultResponse {

    private final long reqId;
    private final Status status;

    public UpdateSemaphoreResultResponse(long reqId, Status status) {
        this.reqId = reqId;
        this.status = status;
    }

    public long getReqId() {
        return reqId;
    }

    public Status getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateSemaphoreResultResponse that = (UpdateSemaphoreResultResponse) o;
        return reqId == that.reqId &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, status);
    }

    @Override
    public String toString() {
        return "UpdateSemaphoreResultResponse{" +
                "reqId=" + reqId +
                ", status=" + status +
                '}';
    }

}
