package ru.yandex.intranet.d.datasource.coordination.rpc;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;

import com.yandex.ydb.coordination.AlterNodeRequest;
import com.yandex.ydb.coordination.AlterNodeResponse;
import com.yandex.ydb.coordination.CreateNodeRequest;
import com.yandex.ydb.coordination.CreateNodeResponse;
import com.yandex.ydb.coordination.DescribeNodeRequest;
import com.yandex.ydb.coordination.DescribeNodeResponse;
import com.yandex.ydb.coordination.DropNodeRequest;
import com.yandex.ydb.coordination.DropNodeResponse;
import com.yandex.ydb.coordination.SessionRequest;
import com.yandex.ydb.coordination.SessionResponse;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.rpc.OutStreamObserver;
import com.yandex.ydb.core.rpc.StreamObserver;

/**
 * YDB coordination RPC.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface CoordinationRpc extends Closeable {

    OutStreamObserver<SessionRequest> session(StreamObserver<SessionResponse> observer, long deadlineAfter);

    CompletableFuture<Result<CreateNodeResponse>> createNode(CreateNodeRequest request, long deadlineAfter);

    CompletableFuture<Result<AlterNodeResponse>> alterNode(AlterNodeRequest request, long deadlineAfter);

    CompletableFuture<Result<DropNodeResponse>> dropNode(DropNodeRequest request, long deadlineAfter);

    CompletableFuture<Result<DescribeNodeResponse>> describeNode(DescribeNodeRequest request, long deadlineAfter);

}
