package ru.yandex.intranet.d.datasource.coordination.rpc.grpc;

import java.util.concurrent.CompletableFuture;

import com.yandex.ydb.coordination.AlterNodeRequest;
import com.yandex.ydb.coordination.AlterNodeResponse;
import com.yandex.ydb.coordination.CreateNodeRequest;
import com.yandex.ydb.coordination.CreateNodeResponse;
import com.yandex.ydb.coordination.DescribeNodeRequest;
import com.yandex.ydb.coordination.DescribeNodeResponse;
import com.yandex.ydb.coordination.DropNodeRequest;
import com.yandex.ydb.coordination.DropNodeResponse;
import com.yandex.ydb.coordination.SessionRequest;
import com.yandex.ydb.coordination.SessionResponse;
import com.yandex.ydb.coordination.v1.CoordinationServiceGrpc;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.OutStreamObserver;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.core.rpc.StreamObserver;
import ru.yandex.intranet.d.datasource.coordination.rpc.CoordinationRpc;

/**
 * GRPC YDB coordination RPC.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class GrpcCoordinationRpc implements CoordinationRpc {

    private final GrpcTransport transport;
    private final boolean transportOwned;

    private GrpcCoordinationRpc(GrpcTransport transport, boolean transportOwned) {
        this.transport = transport;
        this.transportOwned = transportOwned;
    }

    public static GrpcCoordinationRpc useTransport(RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcCoordinationRpc((GrpcTransport) transport, false);
        }
        return null;
    }

    public static GrpcCoordinationRpc ownTransport(RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcCoordinationRpc((GrpcTransport) transport, true);
        }
        return null;
    }

    @Override
    public OutStreamObserver<SessionRequest> session(StreamObserver<SessionResponse> observer, long deadlineAfter) {
        return transport.bidirectionalStreamCall(CoordinationServiceGrpc.getSessionMethod(), observer, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<CreateNodeResponse>> createNode(CreateNodeRequest request, long deadlineAfter) {
        return transport.unaryCall(CoordinationServiceGrpc.getCreateNodeMethod(), request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<AlterNodeResponse>> alterNode(AlterNodeRequest request, long deadlineAfter) {
        return transport.unaryCall(CoordinationServiceGrpc.getAlterNodeMethod(), request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<DropNodeResponse>> dropNode(DropNodeRequest request, long deadlineAfter) {
        return transport.unaryCall(CoordinationServiceGrpc.getDropNodeMethod(), request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<DescribeNodeResponse>> describeNode(DescribeNodeRequest request,
                                                                        long deadlineAfter) {
        return transport.unaryCall(CoordinationServiceGrpc.getDescribeNodeMethod(), request, deadlineAfter);
    }

    @Override
    public void close() {
        if (transportOwned) {
            transport.close();
        }
    }

}
