package ru.yandex.intranet.d.datasource.coordination.spring;

import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

import org.springframework.context.SmartLifecycle;
import org.springframework.lang.NonNull;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.datasource.coordination.ClusterManager;
import ru.yandex.intranet.d.datasource.coordination.model.cluster.ClusterLeader;
import ru.yandex.intranet.d.datasource.coordination.model.cluster.ClusterMembership;
import ru.yandex.intranet.d.datasource.coordination.model.cluster.NodeInfo;
import ru.yandex.intranet.d.datasource.coordination.model.cluster.NodeLeadershipStatus;
import ru.yandex.intranet.d.datasource.coordination.model.session.SessionState;

/**
 * Cluster manager.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class AutoClusterManager implements ClusterManager, SmartLifecycle {

    private final ClusterManager delegate;

    public AutoClusterManager(ClusterManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("Stop not implemented");
    }

    @Override
    public void start() {
        delegate.start();
    }

    @Override
    public void stop(@NonNull Runnable onStop) {
        delegate.stop(onStop);
    }

    @Override
    public boolean isRunning() {
        return delegate.isRunning();
    }

    @Override
    public Mono<Boolean> isLeader() {
        return delegate.isLeader();
    }

    @Override
    public Optional<Boolean> isLeaderCached() {
        return delegate.isLeaderCached();
    }

    @Override
    public Mono<Optional<NodeInfo>> getLeader() {
        return delegate.getLeader();
    }

    @Override
    public Optional<NodeInfo> getLeaderCached() {
        return delegate.getLeaderCached();
    }

    @Override
    public Mono<Boolean> isMember() {
        return delegate.isMember();
    }

    @Override
    public Optional<Boolean> isMemberCached() {
        return delegate.isMemberCached();
    }

    @Override
    public Mono<Set<NodeInfo>> getMembers() {
        return delegate.getMembers();
    }

    @Override
    public Optional<Set<NodeInfo>> getMembersCached() {
        return delegate.getMembersCached();
    }

    @Override
    public Set<NodeInfo> getLastSeenClusterMembers() {
        return delegate.getLastSeenClusterMembers();
    }

    @Override
    public void addLeadershipSubscriber(Consumer<NodeLeadershipStatus> consumer) {
        delegate.addLeadershipSubscriber(consumer);
    }

    @Override
    public void addLeaderSubscriber(Consumer<ClusterLeader> consumer) {
        delegate.addLeaderSubscriber(consumer);
    }

    @Override
    public void addMembershipSubscriber(Consumer<ClusterMembership> consumer) {
        delegate.addMembershipSubscriber(consumer);
    }

    @Override
    public String getNodeId() {
        return delegate.getNodeId();
    }

    @Override
    public String getCurrentVersion() {
        return delegate.getCurrentVersion();
    }

    @Override
    public SessionState getSessionState() {
        return delegate.getSessionState();
    }

    @Override
    public boolean isAutoStartup() {
        return true;
    }

}
