package ru.yandex.intranet.d.datasource.migrations;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.datasource.migrations.impl.MigrationsRunner;

@Component
@Profile({"local"})
public class LocalDatabaseInitializer {

    private static final Logger LOG = LoggerFactory.getLogger(LocalDatabaseInitializer.class);

    private final MigrationsRunner migrationsRunner;

    public LocalDatabaseInitializer(MigrationsRunner migrationsRunner) {
        this.migrationsRunner = migrationsRunner;
    }

    @PostConstruct
    public void postConstruct() {
        LOG.info("Preparing database...");
        migrationsRunner
                .doBootstrap()
                .then(migrationsRunner.applyMigrations())
                .block();
        LOG.info("Database ready");
    }
}
