package ru.yandex.intranet.d.datasource.migrations;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.datasource.migrations.impl.MigrationsRunner;

/**
 * Recipe database initializer.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile({"test-recipe"})
public class RecipeDatabaseInitializer {

    private static final Logger LOG = LoggerFactory.getLogger(RecipeDatabaseInitializer.class);

    private final MigrationsRunner migrationsRunner;

    public RecipeDatabaseInitializer(MigrationsRunner migrationsRunner) {
        this.migrationsRunner = migrationsRunner;
    }

    @PostConstruct
    public void postConstruct() {
        LOG.info("Preparing database...");
        migrationsRunner
                .doBootstrap()
                .then(migrationsRunner.applyMigrations())
                .then(migrationsRunner.applyRecipeMigrations())
                .block();
        LOG.info("Database ready");
    }

}
