package ru.yandex.intranet.d.datasource.migrations.metrics;

import javax.annotation.PostConstruct;

import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.datasource.migrations.impl.MigrationsScheduler;
import ru.yandex.intranet.d.datasource.migrations.model.MigrationsStatus;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Migrations metrics.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile({"dev", "testing", "production", "load-testing"})
public class MigrationsMetrics {

    private final MigrationsScheduler migrationsScheduler;
    private final MetricRegistry metricRegistry;

    public MigrationsMetrics(MigrationsScheduler migrationsScheduler) {
        this.migrationsScheduler = migrationsScheduler;
        this.metricRegistry = MetricRegistry.root();
    }

    @PostConstruct
    public void postConstruct() {
        metricRegistry.lazyGaugeInt64("migrate.db.has.errors", () -> migrationsScheduler.hasError() ? 1L : 0L);
        metricRegistry.lazyGaugeInt64("migrate.db.was.applied",
                () -> migrationsScheduler.getMigrationsStatus() == MigrationsStatus.APPLIED ? 1L : 0L);
        metricRegistry.lazyGaugeInt64("migrate.db.pending.actions", migrationsScheduler::getPendingActionsCount);
        metricRegistry.lazyGaugeInt64("migrate.db.is.pending",
                () -> migrationsScheduler.getMigrationsStatus() == MigrationsStatus.PENDING ? 1L : 0L);
    }

}
