package ru.yandex.intranet.d.datasource.model;

import java.util.List;

import com.yandex.ydb.core.Issue;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.UnexpectedResultException;
import org.apache.commons.lang3.exception.ExceptionUtils;

/**
 * Bad YDB session exception.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class BadSessionException extends UnexpectedResultException {

    public BadSessionException(String message, StatusCode statusCode) {
        super(message, statusCode);
    }

    public BadSessionException(String message, StatusCode statusCode, Throwable cause) {
        super(message, statusCode, cause);
    }

    public BadSessionException(String message, StatusCode statusCode, Issue... issues) {
        super(message, statusCode, issues);
    }

    public static boolean isBadSession(Throwable throwable) {
        List<Throwable> throwableList = ExceptionUtils.getThrowableList(throwable);
        return !throwableList.isEmpty()
                && throwableList.stream().anyMatch(t -> t instanceof BadSessionException);
    }

}
