package ru.yandex.intranet.d.datasource.model;

import java.util.Objects;

/**
 * W.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 29.10.2020
 */
public final class WithTruncatedFlag<T> {
    private final T data;
    private final boolean truncated;

    public WithTruncatedFlag(T data, boolean truncated) {
        this.data = data;
        this.truncated = truncated;
    }

    public T get() {
        return data;
    }

    public boolean isTruncated() {
        return truncated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WithTruncatedFlag<?> that = (WithTruncatedFlag<?>) o;
        return truncated == that.truncated &&
                Objects.equals(data, that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(data, truncated);
    }

    @Override
    public String toString() {
        return "WithTruncatedFlag{" +
                "data=" + data +
                ", truncated=" + truncated +
                '}';
    }
}
