package ru.yandex.intranet.d.datasource.model;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.yandex.ydb.table.values.Type;

/**
 * YDB alter table settings.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class YdbAlterTableSettings {

    private final Map<String, Type> addColumns;
    private final Set<String> dropColumns;

    private YdbAlterTableSettings(Map<String, Type> addColumns, Set<String> dropColumns) {
        this.addColumns = addColumns;
        this.dropColumns = dropColumns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Type> getAddColumns() {
        return addColumns;
    }

    public Set<String> getDropColumns() {
        return dropColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YdbAlterTableSettings that = (YdbAlterTableSettings) o;
        return Objects.equals(addColumns, that.addColumns) &&
                Objects.equals(dropColumns, that.dropColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(addColumns, dropColumns);
    }

    @Override
    public String toString() {
        return "YdbAlterTableSettings{" +
                "addColumns=" + addColumns +
                ", dropColumns=" + dropColumns +
                '}';
    }

    public static final class Builder {

        private final Map<String, Type> addColumns = new LinkedHashMap<>();
        private final Set<String> dropColumns = new HashSet<>();

        private Builder() {
        }

        public Builder addColumn(String name, Type type) {
            addColumns.put(name, type);
            return this;
        }

        public Builder dropColumn(String name) {
            dropColumns.add(name);
            return this;
        }

        public YdbAlterTableSettings build() {
            return new YdbAlterTableSettings(addColumns, dropColumns);
        }

    }

}
