package ru.yandex.intranet.d.datasource.model;

import java.util.Objects;
import java.util.Optional;

import com.yandex.ydb.table.settings.PartitioningPolicy;
import com.yandex.ydb.table.settings.ReplicationPolicy;
import com.yandex.ydb.table.settings.StoragePolicy;

/**
 * YDB create table settings.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class YdbCreateTableSettings {

    private final String presetName;
    private final String executionPolicy;
    private final String compactionPolicy;
    private final PartitioningPolicy partitioningPolicy;
    private final StoragePolicy storagePolicy;
    private final ReplicationPolicy replicationPolicy;

    private YdbCreateTableSettings(String presetName, String executionPolicy, String compactionPolicy,
                                  PartitioningPolicy partitioningPolicy, StoragePolicy storagePolicy,
                                  ReplicationPolicy replicationPolicy) {
        this.presetName = presetName;
        this.executionPolicy = executionPolicy;
        this.compactionPolicy = compactionPolicy;
        this.partitioningPolicy = partitioningPolicy;
        this.storagePolicy = storagePolicy;
        this.replicationPolicy = replicationPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getPresetName() {
        return Optional.ofNullable(presetName);
    }

    public Optional<String> getExecutionPolicy() {
        return Optional.ofNullable(executionPolicy);
    }

    public Optional<String> getCompactionPolicy() {
        return Optional.ofNullable(compactionPolicy);
    }

    public Optional<PartitioningPolicy> getPartitioningPolicy() {
        return Optional.ofNullable(partitioningPolicy);
    }

    public Optional<StoragePolicy> getStoragePolicy() {
        return Optional.ofNullable(storagePolicy);
    }

    public Optional<ReplicationPolicy> getReplicationPolicy() {
        return Optional.ofNullable(replicationPolicy);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YdbCreateTableSettings that = (YdbCreateTableSettings) o;
        return Objects.equals(presetName, that.presetName) &&
                Objects.equals(executionPolicy, that.executionPolicy) &&
                Objects.equals(compactionPolicy, that.compactionPolicy) &&
                Objects.equals(partitioningPolicy, that.partitioningPolicy) &&
                Objects.equals(storagePolicy, that.storagePolicy) &&
                Objects.equals(replicationPolicy, that.replicationPolicy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(presetName, executionPolicy, compactionPolicy, partitioningPolicy, storagePolicy,
                replicationPolicy);
    }

    @Override
    public String toString() {
        return "YdbCreateTableSettings{" +
                "presetName='" + presetName + '\'' +
                ", executionPolicy='" + executionPolicy + '\'' +
                ", compactionPolicy='" + compactionPolicy + '\'' +
                ", partitioningPolicy=" + partitioningPolicy +
                ", storagePolicy=" + storagePolicy +
                ", replicationPolicy=" + replicationPolicy +
                '}';
    }

    public static final class Builder {

        private String presetName;
        private String executionPolicy;
        private String compactionPolicy;
        private PartitioningPolicy partitioningPolicy;
        private StoragePolicy storagePolicy;
        private ReplicationPolicy replicationPolicy;

        private Builder() {
        }

        public Builder presetName(String presetName) {
            this.presetName = presetName;
            return this;
        }

        public Builder executionPolicy(String executionPolicy) {
            this.executionPolicy = executionPolicy;
            return this;
        }

        public Builder compactionPolicy(String compactionPolicy) {
            this.compactionPolicy = compactionPolicy;
            return this;
        }

        public Builder partitioningPolicy(PartitioningPolicy partitioningPolicy) {
            this.partitioningPolicy = partitioningPolicy;
            return this;
        }

        public Builder storagePolicy(StoragePolicy storagePolicy) {
            this.storagePolicy = storagePolicy;
            return this;
        }

        public Builder replicationPolicy(ReplicationPolicy replicationPolicy) {
            this.replicationPolicy = replicationPolicy;
            return this;
        }

        public YdbCreateTableSettings build() {
            return new YdbCreateTableSettings(presetName, executionPolicy, compactionPolicy,
                    partitioningPolicy, storagePolicy, replicationPolicy);
        }

    }

}
