package ru.yandex.intranet.d.datasource.model;

import java.util.Objects;

/**
 * YDB execute data query settings.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class YdbExecuteDataQuerySettings {

    private final boolean keepInQueryCache;

    private YdbExecuteDataQuerySettings(boolean keepInQueryCache) {
        this.keepInQueryCache = keepInQueryCache;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isKeepInQueryCache() {
        return keepInQueryCache;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YdbExecuteDataQuerySettings that = (YdbExecuteDataQuerySettings) o;
        return keepInQueryCache == that.keepInQueryCache;
    }

    @Override
    public int hashCode() {
        return Objects.hash(keepInQueryCache);
    }

    @Override
    public String toString() {
        return "YdbExecuteDataQuerySettings{" +
                "keepInQueryCache=" + keepInQueryCache +
                '}';
    }

    public static final class Builder {

        private boolean keepInQueryCache = true;

        private Builder() {
        }

        public Builder doNotCache() {
            this.keepInQueryCache = false;
            return this;
        }

        public YdbExecuteDataQuerySettings build() {
            return new YdbExecuteDataQuerySettings(keepInQueryCache);
        }

    }

}
