package ru.yandex.intranet.d.datasource.model;

import java.io.Closeable;

import com.yandex.ydb.table.description.DescribePathResult;
import com.yandex.ydb.table.description.ListDirectoryResult;
import reactor.core.publisher.Mono;

/**
 * YDB scheme client.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface YdbSchemeClient extends Closeable {

    Mono<Void> makeDirectory(String path);

    Mono<Void> makeDirectories(String path);

    Mono<Void> removeDirectory(String path);

    Mono<DescribePathResult> describePath(String path);

    Mono<ListDirectoryResult> listDirectory(String path);

}
