package ru.yandex.intranet.d.datasource.model;

import java.util.function.BiFunction;
import java.util.function.Function;

import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.ExplainDataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

import ru.yandex.intranet.d.util.result.Result;
import ru.yandex.intranet.d.util.result.ResultTx;

public interface YdbSession {

    String getId();

    Mono<Void> createTable(String path, TableDescription tableDescriptions, YdbCreateTableSettings settings);

    Mono<Void> createTable(String path, TableDescription tableDescriptions);

    Mono<Void> dropTable(String path);

    Mono<Void> alterTable(String path, YdbAlterTableSettings settings);

    Mono<Void> alterTable(String path);

    Mono<Void> copyTable(String src, String dst);

    Mono<TableDescription> describeTable(String path);

    Mono<DataQueryResult> executeDataQuery(String query, TxControl txControl, Params params,
                                           YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQuery(String query, TxControl txControl, Params params);

    Mono<DataQueryResult> executeDataQuery(String query, TxControl txControl);

    Mono<DataQueryResult> executeDataQueryRetryable(String query, TxControl txControl, Params params,
                                                    YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQueryRetryable(String query, TxControl txControl, Params params);

    Mono<DataQueryResult> executeDataQueryRetryable(String query, TxControl txControl);

    Mono<DataQueryResult> executeDataQueryCommit(String query, TransactionMode txMode, Params params,
                                                 YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQueryCommit(String query, TransactionMode txMode, Params params);

    Mono<DataQueryResult> executeDataQueryCommit(String query, TransactionMode txMode);

    Mono<DataQueryResult> executeDataQueryCommitRetryable(String query, TransactionMode txMode, Params params,
                                                          YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQueryCommitRetryable(String query, TransactionMode txMode, Params params);

    Mono<DataQueryResult> executeDataQueryCommitRetryable(String query, TransactionMode txMode);

    Mono<YdbDataQuery> prepareDataQuery(String query, YdbPrepareDataQuerySettings settings);

    Mono<YdbDataQuery> prepareDataQuery(String query);

    Mono<Void> executeSchemeQuery(String query);

    Mono<ExplainDataQueryResult> explainDataQuery(String query);

    Mono<YdbTransaction> beginTransaction(TransactionMode transactionMode);

    Mono<Void> commitTransaction(String txId);

    Mono<Void> rollbackTransaction(String txId);

    Flux<ResultSetReader> readTable(String tablePath, YdbReadTableSettings settings);

    Flux<ResultSetReader> executeScanQuery(String query, Params params, YdbExecuteScanQuerySettings settings);

    Flux<ResultSetReader> executeScanQuery(String query, Params params);

    Mono<SessionStatus> keepAlive();

    void invalidateQueryCache();

    boolean release();

    Mono<Void> close();

    <T> Mono<T> usingTxMono(TransactionMode transactionMode,
                            Function<YdbTxSession, Mono<T>> body);

    <T> Flux<T> usingTxFlux(TransactionMode transactionMode, Function<YdbTxSession, Flux<T>> body);

    <T> Mono<T> usingTxMonoRetryable(TransactionMode transactionMode, Function<YdbTxSession, Mono<T>> body);

    <T> Flux<T> usingTxFluxRetryable(TransactionMode transactionMode, Function<YdbTxSession, Flux<T>> body);

    YdbTxSession asTx(TxControl txControl);

    YdbTxSession asTxCommit(TransactionMode txMode);

    YdbTxSession asTxCommitRetryable(TransactionMode txMode);

    <U, V, W> Mono<W> usingCompTxMono(TransactionMode txMode,
                                      Function<YdbTxSession, Mono<Tuple2<U, String>>> preamble,
                                      BiFunction<YdbTxSession, U, Mono<V>> body,
                                      BiFunction<YdbTxSession, V, Mono<W>> trailer);

    <U, V, W> Flux<W> usingCompTxFlux(TransactionMode txMode,
                                      Function<YdbTxSession, Flux<Tuple2<U, String>>> preamble,
                                      BiFunction<YdbTxSession, U, Flux<V>> body,
                                      BiFunction<YdbTxSession, V, Flux<W>> trailer);

    <U, V, W> Mono<W> usingCompTxMonoRetryable(TransactionMode txMode,
                                      Function<YdbTxSession, Mono<Tuple2<U, String>>> preamble,
                                      BiFunction<YdbTxSession, U, Mono<V>> body,
                                      BiFunction<YdbTxSession, V, Mono<W>> trailer);

    <U, V, W> Mono<W> usingCompTxRetryable(
                                               Function<YdbTxSession, Mono<WithTxId<U>>> preamble,
                                               BiFunction<YdbTxSession, U, Mono<V>> body,
                                               BiFunction<YdbTxSession, V, Mono<W>> trailer);

    <U, V, W> Mono<Result<W>> usingCompResultTxRetryable(TransactionMode txMode,
                                                         Function<YdbTxSession, Mono<ResultTx<U>>> preamble,
                                                         BiFunction<YdbTxSession, U, Mono<WithTxId<V>>> body,
                                                         BiFunction<YdbTxSession, V, Mono<WithTxId<W>>> trailer);

    <U, V, W> Flux<W> usingCompTxFluxRetryable(TransactionMode txMode,
                                      Function<YdbTxSession, Flux<Tuple2<U, String>>> preamble,
                                      BiFunction<YdbTxSession, U, Flux<V>> body,
                                      BiFunction<YdbTxSession, V, Flux<W>> trailer);

}
