package ru.yandex.intranet.d.datasource.model;

import java.io.Closeable;
import java.util.function.Function;

import com.yandex.ydb.table.stats.SessionPoolStats;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * YDB table client.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface YdbTableClient extends Closeable {

    Mono<YdbSession> getSession();

    <T> Mono<T> usingSessionMono(Function<YdbSession, Mono<T>> body);

    <T> Flux<T> usingSessionFlux(Function<YdbSession, Flux<T>> body);

    <T> Mono<T> usingSessionMonoRetryable(Function<YdbSession, Mono<T>> body);

    <T> Flux<T> usingSessionFluxRetryable(Function<YdbSession, Flux<T>> body);

    SessionPoolStats getSessionPoolStats();

}
