package ru.yandex.intranet.d.datasource.model;

import java.util.Optional;

import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import reactor.core.publisher.Mono;

/**
 * YDB transaction data query.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface YdbTxDataQuery {

    String getId();

    Params newParams();

    Optional<String> getText();

    Mono<DataQueryResult> execute(Params params, YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> execute(Params params);

    Mono<DataQueryResult> execute();

    Mono<DataQueryResult> executeRetryable(Params params, YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeRetryable(Params params);

    Mono<DataQueryResult> executeRetryable();

    Mono<DataQueryResult> executeCommit(TransactionMode txMode, Params params, YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeCommit(TransactionMode txMode, Params params);

    Mono<DataQueryResult> executeCommit(TransactionMode txMode);

    Mono<DataQueryResult> executeCommitRetryable(TransactionMode txMode, Params params,
                                             YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeCommitRetryable(TransactionMode txMode, Params params);

    Mono<DataQueryResult> executeCommitRetryable(TransactionMode txMode);

    TxControl getTxControl();

}
