package ru.yandex.intranet.d.datasource.model;

import java.util.function.BiFunction;
import java.util.function.Function;

import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.ExplainDataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

/**
 * YDB transaction session.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface YdbTxSession {

    String getId();

    Mono<DataQueryResult> executeDataQuery(String query, Params params,
                                           YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQuery(String query, Params params);

    Mono<DataQueryResult> executeDataQuery(String query);

    Mono<DataQueryResult> executeDataQueryRetryable(String query, Params params,
                                                    YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQueryRetryable(String query, Params params);

    Mono<DataQueryResult> executeDataQueryRetryable(String query);

    Mono<DataQueryResult> executeDataQueryCommit(String query, TransactionMode txMode, Params params,
                                                 YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQueryCommit(String query, TransactionMode txMode, Params params);

    Mono<DataQueryResult> executeDataQueryCommit(String query, TransactionMode txMode);

    Mono<DataQueryResult> executeDataQueryCommitRetryable(String query, TransactionMode txMode, Params params,
                                                          YdbExecuteDataQuerySettings settings);

    Mono<DataQueryResult> executeDataQueryCommitRetryable(String query, TransactionMode txMode, Params params);

    Mono<DataQueryResult> executeDataQueryCommitRetryable(String query, TransactionMode txMode);

    Mono<YdbTxDataQuery> prepareDataQuery(String query, YdbPrepareDataQuerySettings settings);

    Mono<YdbTxDataQuery> prepareDataQuery(String query);

    Mono<ExplainDataQueryResult> explainDataQuery(String query);

    Flux<ResultSetReader> readTable(String tablePath, YdbReadTableSettings settings);

    Mono<SessionStatus> keepAlive();

    void invalidateQueryCache();

    <T> Mono<T> usingTxMono(TransactionMode transactionMode, Function<YdbTxSession, Mono<T>> body);

    <T> Flux<T> usingTxFlux(TransactionMode transactionMode, Function<YdbTxSession, Flux<T>> body);

    <T> Mono<T> usingTxMonoRetryable(TransactionMode transactionMode, Function<YdbTxSession, Mono<T>> body);

    <T> Flux<T> usingTxFluxRetryable(TransactionMode transactionMode, Function<YdbTxSession, Flux<T>> body);

    <U, V, W> Mono<W> usingCompTxMono(TransactionMode txMode,
                                      Function<YdbTxSession, Mono<Tuple2<U, String>>> preamble,
                                      BiFunction<YdbTxSession, U, Mono<V>> body,
                                      BiFunction<YdbTxSession, V, Mono<W>> trailer);

    <U, V, W> Flux<W> usingCompTxFlux(TransactionMode txMode,
                                      Function<YdbTxSession, Flux<Tuple2<U, String>>> preamble,
                                      BiFunction<YdbTxSession, U, Flux<V>> body,
                                      BiFunction<YdbTxSession, V, Flux<W>> trailer);

    <U, V, W> Mono<W> usingCompTxMonoRetryable(TransactionMode txMode,
                                               Function<YdbTxSession, Mono<Tuple2<U, String>>> preamble,
                                               BiFunction<YdbTxSession, U, Mono<V>> body,
                                               BiFunction<YdbTxSession, V, Mono<W>> trailer);

    <U, V, W> Flux<W> usingCompTxFluxRetryable(TransactionMode txMode,
                                               Function<YdbTxSession, Flux<Tuple2<U, String>>> preamble,
                                               BiFunction<YdbTxSession, U, Flux<V>> body,
                                               BiFunction<YdbTxSession, V, Flux<W>> trailer);

    TxControl getTxControl();

    Mono<Void> commitTransaction();

    Mono<Void> rollbackTransaction();

}
