package ru.yandex.intranet.d.datasource.utils;

import java.io.Closeable;
import java.io.IOException;

import ru.yandex.intranet.d.datasource.model.YdbTableClient;

/**
 * YDB table client holder for readiness checks.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ReadinessYdbTableClientHolder implements Closeable {

    private YdbTableClient tableClient;

    public ReadinessYdbTableClientHolder(YdbTableClient tableClient) {
        this.tableClient = tableClient;
    }

    public YdbTableClient getTableClient() {
        return tableClient;
    }

    @Override
    public void close() throws IOException {
        tableClient.close();
    }

}
