package ru.yandex.intranet.d.grpc;

import java.util.Optional;

import ru.yandex.intranet.d.grpc.interceptors.IdempotencyKeyInterceptor;

/**
 * GRPC idempotency.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class GrpcIdempotency {

    private GrpcIdempotency() {
    }

    public static Optional<String> idempotencyKey() {
        String idempotencyKey = IdempotencyKeyInterceptor.IDEMPOTENCY_KEY.get();
        return Optional.ofNullable(idempotencyKey);
    }
}
