package ru.yandex.intranet.d.grpc.config;

import java.util.List;

import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.services.HealthStatusManager;
import net.devh.boot.grpc.server.interceptor.GlobalServerInterceptorRegistry;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;

/**
 * GRPC health check configurer.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class GrpcHealthCheckConfigurer implements GrpcServerConfigurer {

    private final GlobalServerInterceptorRegistry globalServerInterceptorRegistry;
    private final HealthStatusManager healthStatusManager;

    public GrpcHealthCheckConfigurer(GlobalServerInterceptorRegistry globalServerInterceptorRegistry,
                                     HealthStatusManager healthStatusManager) {
        this.globalServerInterceptorRegistry = globalServerInterceptorRegistry;
        this.healthStatusManager = healthStatusManager;
    }

    @Override
    public void accept(ServerBuilder<?> serverBuilder) {
        List<ServerInterceptor> interceptors = globalServerInterceptorRegistry.getServerInterceptors();
        BindableService healthCheckService = healthStatusManager.getHealthService();
        ServerServiceDefinition healthCheckServiceDefinition = healthCheckService.bindService();
        ServerServiceDefinition interceptedHealthCheckServiceDefinition = ServerInterceptors
                .interceptForward(healthCheckServiceDefinition, interceptors);
        serverBuilder.addService(interceptedHealthCheckServiceDefinition);
    }

}
