package ru.yandex.intranet.d.grpc.config;

import java.util.List;

import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.services.ProtoReflectionService;
import net.devh.boot.grpc.server.interceptor.GlobalServerInterceptorRegistry;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;

/**
 * GRPC reflection configurer.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class GrpcReflectionConfigurer implements GrpcServerConfigurer {

    private final GlobalServerInterceptorRegistry globalServerInterceptorRegistry;

    public GrpcReflectionConfigurer(GlobalServerInterceptorRegistry globalServerInterceptorRegistry) {
        this.globalServerInterceptorRegistry = globalServerInterceptorRegistry;
    }

    @Override
    public void accept(ServerBuilder<?> serverBuilder) {
        List<ServerInterceptor> interceptors = globalServerInterceptorRegistry.getServerInterceptors();
        BindableService reflectionService = ProtoReflectionService.newInstance();
        ServerServiceDefinition reflectionServiceDefinition = reflectionService.bindService();
        ServerServiceDefinition interceptedReflectionServiceDefinition = ServerInterceptors
                .interceptForward(reflectionServiceDefinition, interceptors);
        serverBuilder.addService(interceptedReflectionServiceDefinition);
    }

}
