package ru.yandex.intranet.d.grpc.interceptors;

import io.grpc.ForwardingServerCallListener;
import io.grpc.ServerCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Call listener to log exceptions.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ExceptionLoggingCallListener<ReqT> extends ForwardingServerCallListener
        .SimpleForwardingServerCallListener<ReqT> {

    private static final Logger LOG = LoggerFactory.getLogger(ExceptionLoggingCallListener.class);

    public ExceptionLoggingCallListener(ServerCall.Listener<ReqT> delegate) {
        super(delegate);
    }

    @Override
    public void onMessage(ReqT message) {
        try {
            super.onMessage(message);
        } catch (Exception e) {
            LOG.error("Unexpected error in GRPC request", e);
            throw e;
        }
    }

    @Override
    public void onHalfClose() {
        try {
            super.onHalfClose();
        } catch (Exception e) {
            LOG.error("Unexpected error in GRPC request", e);
            throw e;
        }
    }

    @Override
    public void onCancel() {
        try {
            super.onCancel();
        } catch (Exception e) {
            LOG.error("Unexpected error in GRPC request", e);
            throw e;
        }
    }

    @Override
    public void onComplete() {
        try {
            super.onComplete();
        } catch (Exception e) {
            LOG.error("Unexpected error in GRPC request", e);
            throw e;
        }
    }

    @Override
    public void onReady() {
        try {
            super.onReady();
        } catch (Exception e) {
            LOG.error("Unexpected error in GRPC request", e);
            throw e;
        }
    }

}
