package ru.yandex.intranet.d.grpc.interceptors;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import net.devh.boot.grpc.common.util.InterceptorOrder;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import org.springframework.core.annotation.Order;

/**
 * GRPC exception logging interceptor.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@GrpcGlobalServerInterceptor
@Order(InterceptorOrder.ORDER_FIRST + 1)
public class ExceptionLoggingInterceptor implements ServerInterceptor {

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers,
                                                                 ServerCallHandler<ReqT, RespT> next) {

        return new ExceptionLoggingCallListener<>(next.startCall(call, headers));
    }

}
