package ru.yandex.intranet.d.grpc.interceptors;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import net.devh.boot.grpc.common.util.InterceptorOrder;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import org.springframework.core.annotation.Order;

/**
 * GRPC idempotency key interceptor.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@GrpcGlobalServerInterceptor
@Order(InterceptorOrder.ORDER_FIRST + 2)
public class IdempotencyKeyInterceptor implements ServerInterceptor {

    public static final Context.Key<String> IDEMPOTENCY_KEY = Context.key("idempotency-key");

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call,
                                                                 Metadata headers,
                                                                 ServerCallHandler<ReqT, RespT> next) {
        String idempotencyKey = headers.get(Metadata.Key.of("Idempotency-Key", Metadata.ASCII_STRING_MARSHALLER));
        Context context;
        if (idempotencyKey != null && !idempotencyKey.isBlank()) {
            context = Context.current().withValue(IDEMPOTENCY_KEY, idempotencyKey);
        } else {
            context = Context.current();
        }
        return Contexts.interceptCall(context, call, headers, next);
    }

}
