package ru.yandex.intranet.d.grpc.interceptors;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;

/**
 * Immutable security context implementation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class YaSecurityContext implements SecurityContext {

    private final Authentication authentication;

    public YaSecurityContext(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public Authentication getAuthentication() {
        return authentication;
    }

    @Override
    public void setAuthentication(Authentication authentication) {
        throw new UnsupportedOperationException("Security context is immutable");
    }

}
