package ru.yandex.intranet.d.grpc.security;

import java.util.Objects;
import java.util.Optional;

/**
 * GRPC authentication attributes for access log.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class GrpcAuthenticationAttributes {

    private final String uid;
    private final Long tvmServiceId;
    private final String oauthClientId;
    private final String oauthClientName;

    public GrpcAuthenticationAttributes(String uid, Long tvmServiceId, String oauthClientId, String oauthClientName) {
        this.uid = uid;
        this.tvmServiceId = tvmServiceId;
        this.oauthClientId = oauthClientId;
        this.oauthClientName = oauthClientName;
    }

    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    public Optional<Long> getTvmServiceId() {
        return Optional.ofNullable(tvmServiceId);
    }

    public Optional<String> getOauthClientId() {
        return Optional.ofNullable(oauthClientId);
    }

    public Optional<String> getOauthClientName() {
        return Optional.ofNullable(oauthClientName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GrpcAuthenticationAttributes that = (GrpcAuthenticationAttributes) o;
        return Objects.equals(uid, that.uid) &&
                Objects.equals(tvmServiceId, that.tvmServiceId) &&
                Objects.equals(oauthClientId, that.oauthClientId) &&
                Objects.equals(oauthClientName, that.oauthClientName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, tvmServiceId, oauthClientId, oauthClientName);
    }

    @Override
    public String toString() {
        return "GrpcAuthenticationAttributes{" +
                "uid='" + uid + '\'' +
                ", tvmServiceId=" + tvmServiceId +
                ", oauthClientId='" + oauthClientId + '\'' +
                ", oauthClientName='" + oauthClientName + '\'' +
                '}';
    }

}
