package ru.yandex.intranet.d.grpc.security;

import java.util.Set;

import com.google.common.primitives.Longs;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.grpc.interceptors.AccessLogServerCall;
import ru.yandex.intranet.d.web.security.model.YaAuthenticationToken;
import ru.yandex.intranet.d.web.security.model.YaCredentials;
import ru.yandex.intranet.d.web.security.model.YaPrincipal;

/**
 * Extracts authentication headers in tests.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Profile({"local", "integration-tests", "load-testing", "test-recipe"})
@Component("yaGrpcAuthenticationConverter")
public class LocalYaGrpcAuthenticationConverter implements GrpcAuthenticationConverter {

    @Override
    public Mono<Authentication> readAuthentication(ServerCall<?, ?> call, Metadata headers) {
        String uid = headers.get(Metadata.Key.of("X-Ya-Uid", Metadata.ASCII_STRING_MARSHALLER));
        String tvmIdHeader = headers.get(Metadata.Key.of("X-Ya-Service-Id", Metadata.ASCII_STRING_MARSHALLER));
        Long tvmId = tvmIdHeader != null ? Longs.tryParse(tvmIdHeader) : null;
        if (uid == null && tvmId == null) {
            return Mono.empty();
        }
        YaAuthenticationToken authentication = new YaAuthenticationToken(new YaPrincipal(uid, tvmId,
                "", "", Set.of()), new YaCredentials());
        if (call instanceof AccessLogServerCall) {
            GrpcAuthenticationAttributes attributes = new GrpcAuthenticationAttributes(uid, tvmId, "", "");
            ((AccessLogServerCall<?, ?>) call).setAuthenticationAttributes(attributes);
        }
        return Mono.just(authentication);
    }

}
