package ru.yandex.intranet.d.grpc.security;

import java.util.Locale;

import com.google.rpc.Code;
import com.google.rpc.Status;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.i18n.Locales;

/**
 * Handler for GRPC requests without necessary permissions.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class PermissionDeniedGrpcRequestHandler {

    private final MessageSource messages;

    public PermissionDeniedGrpcRequestHandler(@Qualifier("messageSource") MessageSource messages) {
        this.messages = messages;
    }

    public <ReqT, RespT> void onRequest(Throwable throwable, ServerCall<ReqT, RespT> call, Metadata headers,
                                         ServerCallHandler<ReqT, RespT> next) {
        Locale locale = Locales.ENGLISH;
        String message = messages.getMessage("errors.access.denied", null, locale);
        Status status = Status.newBuilder()
                .setCode(Code.PERMISSION_DENIED.getNumber())
                .setMessage(message)
                .build();
        final StatusRuntimeException error = StatusProto.toStatusRuntimeException(status);
        call.close(error.getStatus(), error.getTrailers() != null ? error.getTrailers() : new Metadata());
    }

}
