package ru.yandex.intranet.d.grpc.services;

import java.util.Locale;

import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.backend.service.proto.MultilingualGrammaticalForms;
import ru.yandex.intranet.d.backend.service.proto.ProviderExternalAccountUrlTemplate;
import ru.yandex.intranet.d.backend.service.proto.ProviderUISettings;
import ru.yandex.intranet.d.backend.service.proto.ResourceSegment;
import ru.yandex.intranet.d.backend.service.proto.ResourceSegmentPair;
import ru.yandex.intranet.d.backend.service.proto.ResourceSegmentation;
import ru.yandex.intranet.d.i18n.Locales;
import ru.yandex.intranet.d.model.GrammaticalCases;
import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel;

/**
 * CommonConverter.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 22.01.2021
 */
@Component
public class CommonProtoConverter {
    public ResourceSegmentPair toSegment(
            ResourceSegmentationModel segmentation,
            ResourceSegmentModel segment,
            Locale locale
    ) {
        ResourceSegmentPair.Builder builder = ResourceSegmentPair.newBuilder();
        ResourceSegmentation.Builder segmentationBuilder = ResourceSegmentation.newBuilder();
        ResourceSegment.Builder segmentBuilder = ResourceSegment.newBuilder();
        segmentationBuilder.setResourceSegmentationId(segmentation.getId());
        segmentationBuilder.setKey(segmentation.getKey());
        segmentationBuilder.setName(Locales.select(segmentation.getNameEn(), segmentation.getNameRu(), locale));
        segmentationBuilder.setDescription(
                Locales.select(segmentation.getDescriptionEn(), segmentation.getDescriptionRu(), locale));
        segmentBuilder.setResourceSegmentId(segment.getId());
        segmentBuilder.setKey(segment.getKey());
        segmentBuilder.setName(Locales.select(segment.getNameEn(), segment.getNameRu(), locale));
        segmentBuilder.setDescription(Locales.select(segment.getDescriptionEn(), segment.getDescriptionRu(), locale));
        segmentBuilder.setUncommonSegment(segment.getUncommon().orElse(false));
        builder.setSegmentation(segmentationBuilder.build());
        builder.setSegment(segmentBuilder.build());
        return builder.build();
    }

    public ProviderUISettings toProto(ru.yandex.intranet.d.model.providers.ProviderUISettings uiSettings) {
        ProviderUISettings.Builder builder = ProviderUISettings.newBuilder();
        var titleForTheAccount = uiSettings.getTitleForTheAccount();
        if (titleForTheAccount != null) {
            builder.setTitleForTheAccount(toProto(titleForTheAccount));
        }
        return builder.build();
    }

    public ProviderExternalAccountUrlTemplate toProto(
            ru.yandex.intranet.d.model.providers.ExternalAccountUrlTemplate externalAccountUrlTemplate) {
        ProviderExternalAccountUrlTemplate.Builder builder = ProviderExternalAccountUrlTemplate.newBuilder();

        builder.setDefaultTemplate(externalAccountUrlTemplate.getDefaultTemplate());
        builder.setUrlsForSegments(externalAccountUrlTemplate.getUrlsForSegments());
        for (var entry : externalAccountUrlTemplate.getUrlTemplates().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                continue;
            }
            builder.addUrlTemplates(
                    ProviderExternalAccountUrlTemplate.UrlTemplate.newBuilder()
                            .setName(entry.getKey())
                            .setTemplate(entry.getValue())
                            .build());
        }
        for (var entry : externalAccountUrlTemplate.getSegments().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                continue;
            }
            builder.addSegments(
                    ProviderExternalAccountUrlTemplate.Segment.newBuilder()
                            .setSegmentationKey(entry.getKey())
                            .addAllSegmentKey(entry.getValue())
                            .build());
        }
        return builder.build();
    }

    public MultilingualGrammaticalForms toProto(ru.yandex.intranet.d.model.MultilingualGrammaticalForms model) {
        MultilingualGrammaticalForms.Builder builder = MultilingualGrammaticalForms.newBuilder();
        if (model.getNameSingularRu() != null) {
            builder.setNameSingularRu(toProto(model.getNameSingularRu()));
        }
        if (model.getNamePluralRu() != null) {
            builder.setNamePluralRu(toProto(model.getNamePluralRu()));
        }
        if (model.getNameSingularEn() != null) {
            builder.setNameSingularEn(optional(model.getNameSingularEn()));
        }
        if (model.getNamePluralEn() != null) {
            builder.setNamePluralEn(optional(model.getNamePluralEn()));
        }
        return builder.build();
    }

    public MultilingualGrammaticalForms.OptionalString optional(String value) {
        return value != null ? MultilingualGrammaticalForms.OptionalString.newBuilder().setValue(value).build() : null;
    }

    public MultilingualGrammaticalForms.GrammaticalCases toProto(ru.yandex.intranet.d.model.GrammaticalCases model) {
        MultilingualGrammaticalForms.GrammaticalCases.Builder builder =
                MultilingualGrammaticalForms.GrammaticalCases.newBuilder();
        if (model.getNominative() != null) {
            builder.setNominative(model.getNominative());
        }
        if (model.getGenitive() != null) {
            builder.setGenitive(model.getGenitive());
        }
        if (model.getDative() != null) {
            builder.setDative(model.getDative());
        }
        if (model.getAccusative() != null) {
            builder.setAccusative(model.getAccusative());
        }
        if (model.getInstrumental() != null) {
            builder.setInstrumental(model.getInstrumental());
        }
        if (model.getPrepositional() != null) {
            builder.setPrepositional(model.getPrepositional());
        }
        if (model.getLocative() != null) {
            builder.setLocative(model.getLocative());
        }
        return builder.build();
    }

    public ru.yandex.intranet.d.model.MultilingualGrammaticalForms toModel(
            MultilingualGrammaticalForms proto
    ) {
        return new ru.yandex.intranet.d.model.MultilingualGrammaticalForms(
                toModel(proto.getNameSingularRu()),
                toModel(proto.getNamePluralRu()),
                proto.hasNameSingularEn() ? proto.getNameSingularEn().getValue() : null,
                proto.hasNamePluralEn() ? proto.getNamePluralEn().getValue() : null
        );
    }

    private GrammaticalCases toModel(MultilingualGrammaticalForms.GrammaticalCases proto) {
        return new GrammaticalCases(
                proto.getNominative(),
                proto.getGenitive(),
                proto.getDative(),
                proto.getAccusative(),
                proto.getInstrumental(),
                proto.getPrepositional(),
                proto.getLocative()
        );
    }
}
