package ru.yandex.intranet.d.grpc.services;

import java.util.Set;

import ru.yandex.intranet.d.web.model.PatchedValue;

/**
 * Factory for create PatchedValue from GRPC object
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public class PatchedValueGrpcFactory {

    private final Set<String> filedMaskFields;
    private final Set<String> objectFields;
    private final String rootObjectFullName;

    public PatchedValueGrpcFactory(Set<String> filedMaskFields, Set<String> objectFields, String rootObjectFullName) {
        this.filedMaskFields = filedMaskFields;
        this.objectFields = objectFields;
        this.rootObjectFullName = rootObjectFullName;
    }

    public <T> PatchedValue<T> create(T value, String fieldName) {
        String fieldNameFull = rootObjectFullName + "." + fieldName;
        if (filedMaskFields.contains(fieldName)) {
            if (objectFields.contains(fieldNameFull)) {
                return new PatchedValue<>(value);
            } else {
                return new PatchedValue<>(null);
            }
        } else {
            return PatchedValue.noChanged();
        }
    }
}
