package ru.yandex.intranet.d.i18n;

import java.util.List;
import java.util.Locale;

import ru.yandex.intranet.d.grpc.interceptors.LocaleInterceptor;
import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Locale utils.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class Locales {

    public static final Locale ENGLISH = Locale.forLanguageTag("en-US");
    public static final Locale RUSSIAN = Locale.forLanguageTag("ru-RU");
    public static final Locale RUSSIAN_LANG = Locale.forLanguageTag("ru");

    public static final List<Locale> SUPPORTED_LOCALES = List.of(ENGLISH, RUSSIAN, RUSSIAN_LANG);
    public static final Locale DEFAULT_LOCALE = ENGLISH;

    private Locales() {
    }

    public static String select(String english, String russian, Locale locale) {
        if (locale.equals(RUSSIAN) || "ru".equals(locale.getLanguage())) {
            return russian;
        } else {
            return english;
        }
    }

    public static <T> T selectObject(T english, T russian, Locale locale) {
        if (locale.equals(RUSSIAN) || "ru".equals(locale.getLanguage())) {
            return russian != null ? russian : english;
        } else {
            return english != null ? english : russian;
        }
    }

    public static Locale grpcLocale() {
        Locale locale = LocaleInterceptor.LOCALE_KEY.get();
        if (locale != null) {
            return locale;
        }
        return Locales.ENGLISH;
    }

    public static Locale forUser(UserModel user) {
        if (user.getLangUi().isEmpty()) {
            return ENGLISH;
        }
        if ("ru".equals(user.getLangUi().get())) {
            return RUSSIAN;
        }
        return ENGLISH;
    }

    public static String selectFallbackToRu(String english, String russian, Locale locale) {
        if (locale.equals(RUSSIAN) || "ru".equals(locale.getLanguage())) {
            return russian;
        } else {
            return english != null && !english.isBlank() ? english : russian;
        }
    }

}
