package ru.yandex.intranet.d.kotlin

import kotlinx.coroutines.reactor.awaitSingleOrNull
import org.springframework.stereotype.Component
import ru.yandex.intranet.d.dao.accounts.AccountsQuotasDao
import ru.yandex.intranet.d.datasource.model.YdbTxSession
import ru.yandex.intranet.d.model.TenantId
import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel

/**
 * Kotlin wrapper for AccountsQuotasDao.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 03-11-2021
 */
@Component
class AccountsQuotasDaoAdapter(
    private val accountsQuotasDao: AccountsQuotasDao
) {
    suspend fun getAllByResourceIds(
        tx: YdbTxSession, tenantId: TenantId, resourceIds: List<String>
    ): MutableList<AccountsQuotasModel> =
        accountsQuotasDao.getAllByResourceIds(tx, tenantId, resourceIds)
            .awaitSingleOrNull()?.get() ?: mutableListOf()

    suspend fun removeAllModelsRetryable(tx: YdbTxSession, models: List<AccountsQuotasModel>) {
        accountsQuotasDao.removeAllModelsRetryable(tx, models)
            .awaitSingleOrNull()
    }
}
