package ru.yandex.intranet.d.kotlin

import java.util.concurrent.TimeUnit
import java.util.concurrent.atomic.AtomicBoolean

/**
 * Measure elapsed time for coroutine
 */
inline fun <T> elapsed(statement: () -> T,
                        consumer: (elapsedMillis: Long, success: Boolean) -> Unit): T {
    val startedAt = System.nanoTime()
    val success = AtomicBoolean(false)
    try {
        val result = statement()
        success.set(true)
        return result
    } finally {
        val stoppedAt = System.nanoTime()
        val elapsedMillis = TimeUnit.MILLISECONDS.convert(stoppedAt - startedAt, TimeUnit.NANOSECONDS)
        consumer(elapsedMillis, success.get())
    }
}
