package ru.yandex.intranet.d.kotlin

import kotlinx.coroutines.reactor.awaitSingleOrNull
import org.springframework.stereotype.Component
import ru.yandex.intranet.d.dao.folders.FolderOperationLogDao
import ru.yandex.intranet.d.datasource.model.YdbTxSession
import ru.yandex.intranet.d.model.folders.FolderOperationLogModel

/**
 * Kotlin wrapper for FolderOperationLogDao.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 03-11-2021
 */
@Component
class FolderOperationLogDaoAdapter(
    private val folderOperationLogDao: FolderOperationLogDao
) {
    suspend fun upsertAllRetryable(tx: YdbTxSession, models: List<FolderOperationLogModel>) {
        folderOperationLogDao.upsertAllRetryable(tx, models)
            .awaitSingleOrNull()
    }
}
