package ru.yandex.intranet.d.kotlin

import kotlinx.coroutines.reactor.awaitSingleOrNull
import org.springframework.stereotype.Component
import ru.yandex.intranet.d.dao.quotas.QuotasDao
import ru.yandex.intranet.d.datasource.model.YdbTxSession
import ru.yandex.intranet.d.model.TenantId
import ru.yandex.intranet.d.model.quotas.QuotaModel

/**
 * Kotlin wrapper for QuotasDao.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 03-11-2021
 */
@Component
class QuotasDaoAdapter(
    private val quotasDao: QuotasDao
) {
    suspend fun getAllByResourceIds(
        tx: YdbTxSession, tenantId: TenantId, resourceIds: List<String>
    ): MutableList<QuotaModel> =
        quotasDao.getAllByResourceIds(tx, tenantId, resourceIds)
            .awaitSingleOrNull()?.get() ?: mutableListOf()

    suspend fun deleteQuotasByModel(tx: YdbTxSession, quotas: List<QuotaModel>) {
        quotasDao.deleteQuotasByModelRetryable(tx, quotas)
            .awaitSingleOrNull()
    }
}
