package ru.yandex.intranet.d.kotlin

import kotlinx.coroutines.reactor.awaitSingle
import org.springframework.stereotype.Component
import ru.yandex.intranet.d.dao.resources.ResourcesDao
import ru.yandex.intranet.d.datasource.model.YdbTxSession
import ru.yandex.intranet.d.model.TenantId
import ru.yandex.intranet.d.model.resources.ResourceBaseIdentity
import ru.yandex.intranet.d.model.resources.ResourceModel

/**
 * ResourcesDaoAdapter.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 17-11-2021
 */
@Component
class ResourcesDaoAdapter(
    private val resourcesDao: ResourcesDao
) {
    suspend fun getAllByBaseIdentities(
        session: YdbTxSession, identities: List<ResourceBaseIdentity>, withDeleted: Boolean
    ): List<ResourceModel> {
        return resourcesDao.getAllByBaseIdentities(session, identities, withDeleted)
            .awaitSingle()
    }

    suspend fun getAllByProvider(
        session: YdbTxSession, tenantId: TenantId, providerId: String, withDeleted: Boolean
    ): List<ResourceModel> {
        return resourcesDao.getAllByProvider(session, providerId, tenantId, withDeleted)
            .awaitSingle()
    }
}
